/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWWorkObject;
import filenet.vw.api.VWXMLData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminFieldsTableData;
import filenet.vw.toolkit.admin.result.VWAdminLockWork;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminWOTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.VWEditSimpleTypeFieldDialog;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWEditArrayFieldDialog;
import filenet.vw.toolkit.utils.dialog.VWEditXMLFieldDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;

public class VWAdminEditWork {
    private VWAdminResultPane m_resultsPane;
    private VWTable m_resultsTable;
    private int[] m_selectedRows;
    private int[] m_selectedCols;
    private VWAdminResultTableModelBase m_tableModel;
    private Vector m_wobsList = new Vector();
    private Frame m_parentFrame = null;
    private Container m_mainContainer = null;
    private int m_modelColIndex;
    private String m_colName;
    private Vector v_values = new Vector();

    public VWAdminEditWork(VWAdminResultPane resultsPane, boolean editDialog) {
        this.m_resultsPane = resultsPane;
        this.m_selectedRows = this.m_resultsPane.getSelectedRows();
        this.m_selectedCols = this.m_resultsPane.getSelectedCols();
        this.m_tableModel = this.m_resultsPane.getTableModel();
        this.m_resultsTable = this.m_resultsPane.getResultsTable();
        this.m_mainContainer = this.m_resultsPane.getMainContainer();
        this.m_parentFrame = this.m_resultsPane.getParentFrame();
        VWAdminLockWork lockWork = new VWAdminLockWork(this.m_resultsPane, VWResource.s_editFieldsTitle, VWResource.s_askEdit, VWResource.s_override);
        boolean b_cancel = lockWork.getReturnStatus();
        if (b_cancel) {
            this.removeReferences();
            return;
        }
        this.m_wobsList = lockWork.getWorkItemsList();
        if (!editDialog) {
            this.removeReferences();
            return;
        }
        this.m_modelColIndex = this.m_resultsPane.getSelectedModelColIndex(this.m_selectedCols[0]);
        this.m_colName = this.m_tableModel.getColumnName(this.m_modelColIndex);
        this.v_values = this.buildValuesVector();
        VWAdminFieldsTableData data = (VWAdminFieldsTableData)this.m_tableModel.getObjectAt(this.m_selectedRows[0], this.m_selectedCols[0]);
        if (this.v_values != null && this.v_values.size() != 0) {
            if (this.v_values.elementAt(0) instanceof Object[]) {
                this.invokeEditArrayFieldDialog(this.v_values, data.getType());
            } else if (this.v_values.elementAt(0) instanceof VWXMLData) {
                this.invokeEditXMLTypeFieldDialog(this.v_values);
            } else {
                this.invokeEditSimpleTypeFieldDialog(this.v_values);
            }
        }
        this.removeReferences();
    }

    private Vector buildValuesVector() {
        Vector<Object> vector = new Vector<Object>();
        try {
            for (int i = 0; i < this.m_wobsList.size(); ++i) {
                Object value;
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
                VWWorkObject wob = woData.getWob();
                if (wob == null || woData.getLockedStatus() != 1 || !wob.hasFieldName(this.m_colName) || (value = wob.getFieldValue(this.m_colName)) == null) continue;
                vector.addElement(value);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return vector;
    }

    protected void invokeEditArrayFieldDialog(Vector v_values, int nType) {
        VWEditArrayFieldDialog dlg = new VWEditArrayFieldDialog(this.m_parentFrame, this.m_colName, v_values, nType);
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return;
        }
        Object[] returnedValues = dlg.getFieldArray();
        this.setSelectedCellValues(returnedValues);
    }

    protected void invokeEditSimpleTypeFieldDialog(Vector v_values) {
        boolean bCommentsField = this.isSameField(this.m_colName, "F_Comment");
        VWEditSimpleTypeFieldDialog dlg = new VWEditSimpleTypeFieldDialog(this.m_parentFrame, this.m_resultsPane, this.m_colName, v_values, bCommentsField);
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return;
        }
        Object returnedValues = dlg.getFieldArray();
        this.setSelectedCellValues(returnedValues);
        if (!bCommentsField) {
            String sValue = this.m_resultsPane.getSelectedCellValuesInString();
            this.m_resultsPane.updateTextField(sValue);
        }
    }

    protected void invokeEditXMLTypeFieldDialog(Vector v_values) {
        VWXMLData xmlDataObj = null;
        VWXMLData updatedXMLData = null;
        String commonSchema = null;
        String commonElement = null;
        String commonXML = null;
        Vector anotherVector = new Vector();
        for (int i = 0; i < v_values.size(); ++i) {
            anotherVector.addElement(v_values.elementAt(i));
        }
        boolean bUniqueSchema = true;
        boolean bUniqueElement = true;
        boolean bUniqueXML = true;
        String anotherSchema = ((VWXMLData)anotherVector.elementAt(0)).getSchemaName();
        String anotherXML = ((VWXMLData)anotherVector.elementAt(0)).getXML();
        String anotherElement = ((VWXMLData)anotherVector.elementAt(0)).getElementName();
        for (int i = 1; i < v_values.size(); ++i) {
            String XML;
            String element;
            String schema = ((VWXMLData)v_values.elementAt(i)).getSchemaName();
            if (VWStringUtils.compare(anotherSchema, schema) != 0) {
                bUniqueSchema = false;
            }
            if (VWStringUtils.compare(anotherElement, element = ((VWXMLData)v_values.elementAt(i)).getElementName()) != 0) {
                bUniqueElement = false;
            }
            if (VWStringUtils.compare(anotherXML, XML = ((VWXMLData)v_values.elementAt(i)).getXML()) == 0) continue;
            bUniqueXML = false;
        }
        commonSchema = !bUniqueSchema ? VWResource.s_variousValues : anotherSchema;
        commonElement = !bUniqueElement ? VWResource.s_variousValues : anotherElement;
        commonXML = !bUniqueXML ? VWResource.s_variousValues : anotherXML;
        try {
            xmlDataObj = new VWXMLData(commonXML, commonSchema, commonElement);
            VWEditXMLFieldDialog editXMLDialog = new VWEditXMLFieldDialog(this.m_parentFrame, xmlDataObj);
            editXMLDialog.setVisible(true);
            int nEditXMLDialogReturn = editXMLDialog.getExitStatus();
            if (nEditXMLDialogReturn != 0) {
                return;
            }
            updatedXMLData = editXMLDialog.getVWXMLData();
            this.setSelectedCellValues(updatedXMLData);
            String sValue = this.m_resultsPane.getSelectedCellValuesInString();
            this.m_resultsPane.updateTextField(sValue);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean isSameField(String fieldName, String authoredName) {
        for (int i = 0; i < this.m_wobsList.size(); ++i) {
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
            VWWorkObject wob = woData.getWob();
            try {
                VWDataField dataField;
                if (!wob.hasFieldName(fieldName) || (dataField = wob.getDataField(fieldName)) == null) continue;
                return VWStringUtils.compare(dataField.getAuthoredName(), authoredName) == 0;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return false;
    }

    private void setSelectedCellValues(Object returnedValues) {
        if (this.m_tableModel == null || !(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return;
        }
        Object value = null;
        try {
            for (int i = 0; i < this.m_wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
                VWWorkObject wob = woData.getWob();
                if (woData.getRowIndex() < 0 || (value = this.m_tableModel.getObjectAt(woData.getRowIndex(), this.m_modelColIndex)) == null || !(value instanceof VWAdminFieldsTableData)) continue;
                this.m_resultsPane.updateCellValues(returnedValues, woData.getRowIndex(), this.m_modelColIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void removeReferences() {
        if (this.m_wobsList != null) {
            this.m_wobsList.removeAllElements();
        }
        if (this.v_values != null) {
            this.v_values.removeAllElements();
        }
    }
}

